unit fROR_XMLEngine;
{
================================================================================
*
*       Package:        ROR - Clinical Case Registries
*       Date Created:   $Revision: 8 $  $Modtime: 4/12/07 3:47p $
*       Site:           Hines OIFO
*       Developers:
*                                      
*
*       Description:    XML engine
*
*       Notes:
*
================================================================================
*       $Archive: /CCR v1.5/Current/fROR_XMLEngine.pas $
*
* $History: fROR_XMLEngine.pas $
 * 
 * *****************  Version 8  *****************
 * User: Vhaishgavris Date: 4/12/07    Time: 4:00p
 * Updated in $/CCR v1.5/Current
 * 
 * *****************  Version 7  *****************
 * User: Vhaishgavris Date: 3/08/07    Time: 1:47p
 * Updated in $/CCR v1.5/Current
 * 
 * *****************  Version 6  *****************
 * User: Vhaishgavris Date: 10/26/05   Time: 11:14a
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 5  *****************
 * User: Vhaishgavris Date: 1/10/05    Time: 3:48p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 4  *****************
 * User: Vhaishgavris Date: 10/14/04   Time: 3:50p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 3  *****************
 * User: Vhaishgavris Date: 10/21/03   Time: 5:06p
 * Updated in $/ICR v3.0/Current
 * 
 * *****************  Version 2  *****************
 * User: Vhaishgavris Date: 9/11/03    Time: 10:54p
 * Updated in $/ICR v3.0/Current
 * 
 * *****************  Version 1  *****************
 * User: Vhaishgavris Date: 9/11/03    Time: 5:03p
 * Created in $/ICR v3.0/Current
 * 
 * *****************  Version 1  *****************
 * User: Vhaishandria Date: 7/31/03    Time: 12:41p
 * Created in $/ICR v3.0/Current
*
================================================================================
}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, SablotEngine, sHandler, TRPCB, uROR_Common, uROR_Broker;

type
  TXMLEngine = class(TForm)
    FSablotEngine: TSablotEngine;
    SchemeProxy: TSchemeProxy;
    procedure FSablotEngineMsgDebug(Sender: TObject;
      const ErrorCode: Integer; var Fields: TSErrorFields);
    procedure FSablotEngineMsgError(Sender: TObject;
      const ErrorCode: Integer; var Fields: TSErrorFields);
    procedure SchemeProxyHasHandle(Sender: TObject; handle: Integer;
      var Result: Boolean);
    procedure SchemeProxyFreeMemory(Sender: TObject; buffer: PAnsiChar);
    procedure SchemeProxyGet(Sender: TObject; const handle: Integer;
      var buffer: PAnsiChar; var bytecount: Integer);
    procedure SchemeProxyGetAll(Sender: TObject; const scheme,
      rest: PAnsiChar; var buffer: PAnsiChar; var bytecount: Integer);
    procedure SchemeProxyOpen(Sender: TObject; const scheme,
      rest: PAnsiChar; var handle: Integer);
    procedure SchemeProxyPut(Sender: TObject; const handle: Integer;
      const buffer: PAnsiChar; var byteCount: Integer);
  private

    FErrors: TStringList;
    FReportDescr: String;

    FTestXML: integer;
    FTestXSL: integer;

    Broker: TCCRBroker;
    RPCBuf: TStringList;
    Task: String;
    SortMode: TStringList;
    InputBuffer: String;
    InputEOS: Boolean;
    InputFrom: String;
    OutputStream: TStream;

  public

    property Errors: TStringList read FErrors;
    property ReportDescr: String read FReportDescr;

    constructor Create(aBroker: TCCRBroker); reintroduce;
    destructor  Destroy; override;

    function TransformReport(aTask: String; Output: TStream;
      Template: String = ''; aSortMode: TStringList = nil): Boolean;

  published

    property SablotEngine: TSablotEngine read FSablotEngine;

  end;

implementation
{$R *.DFM}

uses
  uROR_Utilities;

const
  sReportScheme   = 'report';
  sTemplateScheme = 'template';
  sOutputScheme   = 'output';

constructor TXMLEngine.Create(aBroker: TCCRBroker);
begin
  inherited Create(Application);
  Broker := aBroker;
  FReportDescr := 'Report';
  RPCBuf := TStringList.Create;
  OutputStream := nil;
  SortMode := nil;
  FErrors := TStringList.Create;
  FTestXML := 0;
  FTestXSL := 0;
  SchemeProxy.AddScheme(sReportScheme);
  SchemeProxy.AddScheme(sOutputScheme);
  SchemeProxy.AddScheme(sTemplateScheme);
end;

destructor  TXMLEngine.Destroy;
begin
  FErrors.Free;
  RPCBuf.Free;
  inherited Destroy;
end;

procedure TXMLEngine.FSablotEngineMsgError(Sender: TObject;
  const ErrorCode: Integer; var Fields: TSErrorFields);
begin
  FErrors.Add(SablotEngine.LastError);
end;

procedure TXMLEngine.FSablotEngineMsgDebug(Sender: TObject;
  const ErrorCode: Integer; var Fields: TSErrorFields);
begin
  FErrors.Add(SablotEngine.LastDebug);
end;

procedure TXMLEngine.SchemeProxyFreeMemory(Sender: TObject;
  buffer: PAnsiChar);
begin
  buffer := '';
end;

procedure TXMLEngine.SchemeProxyHasHandle(Sender: TObject; handle: Integer;
  var Result: Boolean);
begin
  Result := False;
  if (handle = 1) Or (handle = 2) then
    Result := True;
end;

function TXMLEngine.TransformReport(aTask: String; Output: TStream;
  Template: String; aSortMode: TStringList): Boolean;
var
  rptcode: String;
  oldCursor: TCursor;
begin
  Result := False;
  oldCursor := Screen.Cursor;
  Screen.Cursor := crHourGlass;
  try
    FErrors.Clear;
    if Assigned(aSortMode) then
      SortMode := aSortMode;

    if Broker.CallProc(rpcTaskInfo, [aTask]) then
      begin
        rptcode := Piece(Broker.Results[4],'^');
        FReportDescr := Broker.Results[5];
        if FReportDescr = '' then
          FReportDescr := 'Report #' + rptcode;
      end
    else
      rptcode := '';

    if rptcode <> '' then
      begin
        OutputStream := Output;
        OutputStream.Size := 0;
        Task := aTask;
        Result := SablotEngine.RunProcessorGen(
          sTemplateScheme + '://report/' + rptcode + '/' + Template,
          sReportScheme + '://',
          sOutputScheme + '://' );
      end;
  finally
    SortMode := nil;
    Screen.Cursor := oldCursor;
  end;
end;

procedure TXMLEngine.SchemeProxyGet(Sender: TObject; const handle: Integer;
  var buffer: PAnsiChar; var bytecount: Integer);
var
  slen: Integer;
  TestMode: boolean;
  {$IFDEF DBUGETM1}
  DebugETM: TextFile;
  DebugETMisTrue: boolean;
  DebugETMXMLisTrue: boolean;
  {$ENDIF}
begin
  TestMode := (FTestXML > 0);
  {$IFDEF DBUGETM1}
  DebugETMisTrue := FileExists('C:\ETM\DEBUG-ETM-1.txt');
  if DebugETMisTrue then
  begin
    System.AssignFile(DebugETM, 'C:\ETM\DEBUG-ETM-1.txt');
    System.Append(DebugETM);
  end;
  DebugETMXMLisTrue :=  FileExists('C:\ETM\DEBUG-ETM-1.xml');
  TestMode := DebugETMXMLisTrue;
  {$ENDIF}
  if handle = 1 then
    begin
      if Not InputEOS then
        if Broker.CallProc(rpcReportRetrieve,
            [Task,InputFrom,IntToStr(bytecount)+'B'], SortMode, RPCBuf) then
          begin
            InputFrom := RPCBuf.Strings[0];
            if StrToIntDef(Piece(InputFrom,'^'),0) <= 0 then
              InputEOS := True;
            RPCBuf.Delete(0);
            {$IFDEF DBUGETM1}
            if DebugETMXMLisTrue and (FTestXML = 0) then
            begin
              FTestXML := 1;
              RPCBuf.Clear;
              RPCBuf.LoadFromFile('C:\ETM\DEBUG-ETM-1.xml');
              buffer := RPCBuf.GetText;
              bytecount := strlen(buffer) + 1;
            end
            else if DebugETMXMLisTrue then
              bytecount := 0;

            if DebugETMisTrue then
            begin
              writeln(DebugETM, '*******In TXMLEngine.SchemeProxyGet******');
              writeln(DebugETM, 'RPC = ' + rpcReportRetrieve);
              writeln(DebugETM, 'RPCBuf=['+RPCBuf.Text+']');
            end;
            {$ENDIF}
            InputBuffer := InputBuffer + RPCBuf.Text;
            RPCBuf.Clear;
          end
        else
          bytecount := 0;

      if bytecount > 0 then
        begin
          slen := Length(InputBuffer);
          if slen > bytecount then
            slen := bytecount
          else
            bytecount := slen;
          Move(InputBuffer[1], buffer, slen);
          Delete(InputBuffer, 1, slen);
        end;
    end;
  {$IFDEF DBUGETM1}
  if DebugETMisTrue then
  begin
    writeln(DebugETM, '*******End of TXMLEngine.SchemeProxyGet******');
    System.CloseFile(DebugETM);
  end;
  {$ENDIF}
end;

procedure TXMLEngine.SchemeProxyGetAll(Sender: TObject; const scheme,
  rest: PAnsiChar; var buffer: PAnsiChar; var bytecount: Integer);
var
  buf, rptcode, template: String;
  TestMode: boolean;
  {$IFDEF DBUGETM2}
  DebugETM: TextFile;
  DebugETMisTrue: boolean;
  DebugETMXSLisTrue: boolean;
  {$ENDIF}
begin
  bytecount := 0;
  TestMode := (FTestXSL > 0);
  {------------------------------------------------
    URL: template://report/5/1
   ------------------------------------------------}
  {$IFDEF DBUGETM2}
  DebugETMisTrue := FileExists('C:\ETM\DEBUG-ETM-2.txt');
  if DebugETMisTrue then
  begin
    System.AssignFile(DebugETM, 'C:\ETM\DEBUG-ETM-2.txt');
    System.Append(DebugETM);
  end;
  {$ENDIF}
  if LowerCase(scheme) = sTemplateScheme then
  begin
    buf := UpperCase(rest);
    if Pos('REPORT/', buf) > 0 then
    begin
      buf := Piece(buf, 'REPORT/', 2);
      rptcode := Piece(buf, '/');
      template := Piece(buf, '/', 2);
      if Broker.CallProc(rpcReportStylesheet, [rptcode, template], nil, RPCBuf) then
      begin
        {$IFDEF DBUGETM2}
        DebugETMXSLisTrue := FileExists('C:\ETM\DEBUG-ETM-2.xsl'+template);
        TestMode := DebugETMXSLisTrue;
        if DebugETMXSLisTrue and (FTestXSL = 0) then
        begin
          FTestXSL := 1;
          RPCBuf.Clear;
          RPCBuf.LoadFromFile('C:\ETM\DEBUG-ETM-2.xsl'+template);
          buffer := RPCBuf.GetText;
          bytecount := strlen(buffer) + 1;
        end
        else if DebugETMXSLisTrue then
          bytecount := 0;

        if DebugETMisTrue then
        begin
          writeln(DebugETM, '*******In TXMLEngine.SchemeProxyGetAll******');
          writeln(DebugETM, 'RPC = ' + rpcReportStylesheet);
          writeln(DebugETM, 'RPCBuf=['+RPCBuf.Text+']');
        end;
        {$ENDIF}

        if TestMode = false then
        begin
          buffer := RPCBuf.GetText;
          bytecount := strlen(buffer) + 1;
        end;
        RPCBuf.Clear;
      end;
    end
  end;
  {$IFDEF DBUGETM2}
  if DebugETMisTrue then
  begin
    writeln(DebugETM, '*******End of TXMLEngine.SchemeProxyGetAll******');
    System.CloseFile(DebugETM);
  end;
  {$ENDIF}
end;

procedure TXMLEngine.SchemeProxyOpen(Sender: TObject; const scheme,
  rest: PAnsiChar; var handle: Integer);
begin
  handle := 0;
  if scheme = sReportScheme then
    begin
      InputBuffer := '';
      InputFrom := '';
      InputEOS := False;
      handle := 1;
    end
  else if scheme = sOutputScheme then
    begin
      OutputStream.Size := 0;
      handle := 2;
    end;
end;

procedure TXMLEngine.SchemeProxyPut(Sender: TObject; const handle: Integer;
  const buffer: PAnsiChar; var byteCount: Integer);
begin
  if handle = 2 then
    OutputStream.WriteBuffer(buffer^, bytecount);
end;

end.
